@extends($activeTemplate.'layouts.master')
@section('content')

<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
.tooltip {
  position: relative;
  display: inline-block;
}

.tooltip .tooltiptext {
  visibility: hidden;
  width: 140px;
  background-color: #555;
  color: #fff;
  text-align: center;
  border-radius: 6px;
  padding: 5px;
  position: absolute;
  z-index: 1;
  bottom: 150%;
  left: 50%;
  margin-left: -75px;
  opacity: 0;
  transition: opacity 0.3s;
}

.tooltip .tooltiptext::after {
  content: "";
  position: absolute;
  top: 100%;
  left: 50%;
  margin-left: -5px;
  border-width: 5px;
  border-style: solid;
  border-color: #555 transparent transparent transparent;
}

.tooltip:hover .tooltiptext {
  visibility: visible;
  opacity: 1;
}
</style>
</head>
<body>

<div style="display:none;">
<input type="text" value="{{ route('home') }}?reference={{ auth()->user()->username }}" id="myInput">
</div>




<script>
function myFunction() {
  var copyText = document.getElementById("myInput");
  copyText.select();
  copyText.setSelectionRange(0, 99999);
  navigator.clipboard.writeText(copyText.value);
  
  var tooltip = document.getElementById("myTooltip");
  tooltip.innerHTML = "Copied: " + copyText.value;
}

function outFunc() {
  var tooltip = document.getElementById("myTooltip");
  tooltip.innerHTML = "Copy to clipboard";
}
</script>
</body>
</html>



@php
  $authUser = Auth::user();
  $balance = number_format($authUser->balance, 0, '.', '');
@endphp



@php
    use App\Models\Transaction;
    $authUserId = Auth::id();
    $referralCommission = Transaction::where('user_id', $authUserId)
                                    ->where('remark', 'referral_commission')
                                    ->sum('amount');
    $formattedReferralCommission = number_format($referralCommission, 0, '.', '');
@endphp


@php
    $authUserId = Auth::id();
    $ptcEarn = Transaction::where('user_id', $authUserId)
                            ->where('remark', 'ptc_earn')
                            ->sum('amount');
    $formattedPtcEarn = intval($ptcEarn);
@endphp


@php
  use App\Models\Withdrawal;
  $authUserId = Auth::id();
  $withdrawal = Withdrawal::where('user_id', $authUserId)
                          ->where('status', 2)
                          ->first();
  $finalAmount = $withdrawal ? number_format($withdrawal->final_amount, 0, '.', '') : 0;
@endphp

@php
  $authUserId = Auth::id();
  $withdrawal = Withdrawal::where('user_id', $authUserId)
                          ->where('status', 1)
                          ->first();
  $withdrawalAmount = $withdrawal ? number_format($withdrawal->final_amount, 0, '.', '') : 0;
  

@endphp

@php
  $authUserId = Auth::id();
  $withdrawal = Withdrawal::where('user_id', $authUserId)
                          ->where('status', 3)
                          ->first();
  $withdrawalAmountre = $withdrawal ? number_format($withdrawal->final_amount, 0, '.', '') : 0;
  
$pageTitle = 'wallet';
@endphp

<div class="information-foot navbar-foot">
    <div class="invite-content">
        <div class="invite-main">
            <div class="invite-main-content">
                <div class="invite-dd invite-code">
                    <span>Invite Code</span>
                    <div class="invite-code-info copy"
                         data-clipboard-text="{{ route('home') }}?reference={{ auth()->user()->username }}">{{ auth()->user()->username }}</div>
                </div>
                <div class="invite-dd invite-qrcode">
                    <img src="{{asset ('core/img/1.png')}}">
                </div>
            </div>
            
            <button onclick="myFunction()" onmouseout="outFunc()">
  <span class="tooltiptext" id="myTooltip">Copy Link</span>
  
  </button>
            @php
  $authUser = Auth::user();
  $userCount = App\Models\User::where('ref_by', $authUser->id)->count();
@endphp
        </div>
        <div class="my-team">
            <ul>
                <li>
                    <span>     {{ $userCount }}</span>
                    <label>Invite</label>
                </li>
                <li>
                    <span>{{ $referralCommission }} {{ $general->cur_text }}</span>
                    <label>Team Income</label>
                </li>
            </ul>
        </div>
        <div class="team-head">
            <div class="team-tab">
                                    <a href="" class="active">
                        B（1）
                    </a>
                                                    <a href="">
                        C（0）
                    </a>
                                                    <a href="">
                        D（0）
                    </a>
                            </div>
        </div>
        <div class="team-option">
            



          @if($user->allReferrals->count() > 0 && $maxLevel > 0)
          
            <div class="card">
                <div class="card-body">
                    <div class="treeview-container">
                        <ul class="treeview">
                        <li class="items-expanded"> {{ $user->fullname }} ( {{ $user->username }} )
                                @include($activeTemplate.'partials.under_tree',['user'=>$user,'layer'=>0,'isFirst'=>true])
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

@endsection

@push('style')
    <link href="{{ asset('assets/global/css/jquery.treeView.css') }}" rel="stylesheet" type="text/css">
@endpush
@push('script')
<script src="{{ asset('assets/global/js/jquery.treeView.js') }}"></script>
<script>
    (function($){
    "use strict"
        $('.treeview').treeView();
        $('.copyBoard').click(function(){
                var copyText = document.getElementsByClassName("copyURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);

                /*For mobile devices*/
                document.execCommand("copy");
                $('.copyText').text('Copied');
                setTimeout(() => {
                    $('.copyText').text('Copy');
                }, 2000);
        });
    })(jQuery);
</script>
@endpush
